---
obsidianUIMode: preview
---

The following village description and adventure from *[Sly Flourish's Fantastic Adventures](https://shop.slyflourish.com/products/fantastic-adventures)* are released under the same Creative Commons license as the rest of this document. These sections give RPG publishers a small village setting and starter adventure under an open license and royalty free. Please note that the rest of *Fantastic Adventures* has not been released under this license.

Nestled between mountains to the east and west and swampland and forest to the south, the village of Whitesparrow serves as respite for those who travel along the modest trade route running through the surrounding valley. An old keep overlooks this village of five hundred people from an adjacent hill, with banners depicting the settlement’s namesake bird fluttering from its square turrets.

After the keep, a great hand carved of black stone is Whitesparrow’s second-most-visible landmark, rising up at the center of the village with its thumb and five fingers splayed out. The area around the hand is a great dig, where previous generations tried and failed to excavate whatever lay beneath it.

An open-air stone temple, a two-story inn built atop steaming hot springs, and an outfitters’ shop stand among two dozen other buildings that make up the heart of the village, while farmhouses dot the neighboring hillsides, surrounded by broad fields of crops.

**Area Aspects:** Cyclopean hand, old keep, outfitters, open-air temple, hot spring inn

## Using Whitesparrow in Your Campaign

The village of Whitesparrow serves as the hub for\
the adventures in this book, so as to save on the space required to write a new starting location for each adventure, and to give the characters a well-defined home base. The design of the village is both straightforward and spare, featuring an inn, a tavern, an outfitters, a sheriff, and the village lord. Whitesparrow has thus been designed to fit easily into any fantasy world—but also to be completely replaceable with any settlement of your choice from your own campaign word, another published adventure, or a larger published campaign setting. Use the village as is, modify it to suit your own campaign, or throw it out and replace it completely.\
It’s up to you.

## Notable NPCs of Whitesparrow

**Sheriff Ruth Willowmane**: Sheriff Ruth Willow-mane is the true protector and unofficial leader of the village. The middle-aged sheriff has served the people of Whitesparrow for twenty years, after serving as a soldier for fifteen years before that. She has a good heart and loves the people of the village, who always look to her when trouble arises. She typically has little patience for adventurers, seeing them as disruptive influences on the normal flow of village life—and fearing the trouble they often bring with them. Still, she understands that the threats represented by the odd events that often transpire around the village require special skills to deal with, and she looks to those with a proven ability to handle themselves to deal with those threats.

The sheriff has eight guards under her employ and can call upon another twelve conscripted guards when needed.

**Lord Marlin Whitesparrow**: Lord Marlin White-sparrow is the young lord of the village and the lands around it. He resides in the old castle that sits on a hill above the village, an inheritance passed down through his family for generations. Marlin’s father died in his fifties and left his thirty-year old son in charge. Despite his young age, Lord Whitesparrow is a well-respected leader, though he has little patience for the daily drudgery of village life.

Marlin has no wife or children, but the lord has adopted his young nephew Pennin as ward after the boy’s parents died of influenza when he was a baby. Pennin will succeed Marlin if the lord dies. If both die, the Whitesparrow line is broken and Sheriff Ruth Willowmane becomes the new elected leader of the village.

**Amanda Jess**: Owner of the Summerspring Inn and the Evershady Tavern, Amanda Jess is the dominant entrepreneur in Whitesparrow. She has three sons—Kinzlow, Balaham, and Wess—who work at the tavern and inn. Amanda enjoys meeting visitors to Whitesparrow, and she has an eye for people. She has a knack for knowing exactly what questions to ask in order to dig deep into newcomers’ backgrounds, and always seeks a way to find opportunities for business. Some whisper that Amanda was once a spy for a powerful organization before she retired to the quiet life of Whitesparrow.

**Gavun Grayhorn**: A former adventurer, Gavun is the proprietor of Grayhorn Outfitters. He once traveled far and wide across many lands, but fortune always eluded him. When one adventure left him the only survivor of his group, Gavun retired to start his business and serve the many trading caravans passing through the local area—just as those caravans began to turn to safer paths that took them away from Whitesparrow. Such is the luck of Gavun Grayhorn. He runs the shop with his wife Arianne, whose family has dwelled in Whitesparrow for generations.

**Elovyn Sorrowsong**: An elf priest of the Temple of Light, Elovyn found herself out of political favor in her homeland and was sent on a one-hundred-year pilgrimage into the lands of humankind. Though she still resents being sent on the pilgrimage, and the decades she has spent in Whitesparrow as a result, she has come to care very much for the people of the village. She greatly enjoys the empowerment that comes with being Whitesparrow’s only elf in a position of authority. Because of this, she is initially distrustful of other elves who visit the village, afraid they will take away from her mystique.

**Philcock Deadcleft**: The manager of the Summer-spring Inn and a longtime employee of Amanda Jess, Deadcleft is a small, ugly rumormonger who spies on his patrons. Yet for reasons unknown, Amanda has always protected and defended him. Deadcleft wears clothes of noble cut but in poor condition, and always smells terrible.

## Notable Locations of Whitesparrow

### The Cyclopean Palm

**Area Aspects:** Titanic six-fingered hand rising out of the ground, unknown and indestructible substance, deep excavations, rumored staircase

> *A great hand carved of smooth black stone rises in the center of the village, its palm facing the sky and its thumb and five fingers splayed out. The cyclopean stonework is nearly forty feet high—tall enough that buildings have been constructed around it and a tavern sits underneath the shade of the back of the hand. Deep clefts have been dug in around the hand’s wrist, confirming that it is attached to a forearm descending far beneath the ground.*

The age of the stone hand jutting out of the ground has never been accurately determined, and its origin remains unknown. Its stone is seemingly impervious to damage, and resembles no other type of local rock. A number of explorers and miners have tried to dig out the rest of this amazing construction over the years. However, most such attempts were abandoned when their crews began to complain of nightmares filled with strange buzzing sounds. Some of the clefts left behind by these excavation efforts still exist, with old rope ladders leading down roughly one hundred feet to the bend at the elbow of the arm.

A rumor continuously floats around Whitesparrow talking of how the hand’s wrist is hollow, and of a staircase carved into it that leads down below the surface. A chamber within the arm is said to be the boundary between two worlds. However, most pass this rumor off as a fantasy, spoken of by drunkards and sketched onto false maps sold for a few silver to travelers awed by the spectacle of the cyclopean palm.

### The Evershady Tavern

**Area Aspects:** Continual shade under the cyclopean palm, indoor and outdoor tables, circular bar around the wrist

> *Underneath the great palm rests the building and outdoor eatery that is the Evershady Tavern. A half-circle bar has been built around the wrist of the upthrust hand, and numerous tables rest beneath the shade of the palm. Ropes and nets filled with foodstuffs hang from the hand’s splayed fingers.*

The enterprising Amanda Jess built this tavern four decades earlier, and has since turned it into an enduring and profitable business. The tavern serves travelers and workers for miles around, featuring a spiced lamb stew known far and wide as one of the best dishes in the local area. The recipe is kept secret, but some think that the proximity of the tavern’s kitchens to the cyclopean palm plays some part in its potency. The vast cellars below the tavern were dug out by various expeditions seeking the secrets of the cyclopean palm, but which never uncovered anything but bankruptcy and madness.

### The Summerspring Inn

**Area Aspects:** Underground hot springs, creaking and rotting wood, large support beams

> *This large, two-story building seems to sit slightly askew, supported at its corners by heavy beams that keep it from collapsing completely. Whenever the wind blows, the whole building makes a deep creaking sound, like someone trying to get comfortable in a tilting chair.*

The Summerspring Inn’s most notable feature is the hot springs on which it sits—and which are also the cause of its potential demise. The continual humidity has soaked into the wood of the building, rotting much of it and putting the entire structure on the edge of collapse. Maintaining the inn is now a full-time endeavor, and workers are continually reinforcing beams and adding new supports where the floors have begun to sag.

The lower rooms of the inn include their own stone hot baths, continually fed by the slightly sulfuric-smelling hot springs. Some of those springs have unexpectedly gone dry over the years, leaving a network of caverns below the inn said to contain untouched gemstone deposits, lost relics, and secret horrors. Amanda Jess owns this inn as well as the Evershady Tavern, but she relegates the inn’s daily management to Philcock Deadcleft.

### Grayhorn Outfitters

**Area Aspects:** Shop and stables, huge horns above door, clutter and mess

> *A pair of huge black horns protrudes out from above the heavy wooden door of this large shop. A horseshoe, a bundle of rope, and a pickaxe are carved into the sign that hangs overhead. One side of the building features a stable with twelve stalls, presently holding four well-worked draft horses and a beautiful white stallion.*

Gavun Grayhorn’s shop is a cluttered mess holding all forms of tack and equipment, including both adventuring and exploration gear. Gavun reluctantly brings out arms and armor if asked, though he doesn’t seem very fond of such items. If asked about the horns above the door, he says he found them out in the woods, attached to the skull of some unknown herbivore. In reality, they are the horns of the black dragon that slew Gavun’s companions when he was an adventurer—in response to which he took bloody revenge by feeding the dragon a dead yak concealing six pots of alchemist’s fire. The dragon’s lair still holds the remains of Gavun’s companions and their equipment, all of which he hopes to recover some day—were it not for the monsters that have since taken up residence within the abandoned lair.

### The Temple of Light

**Area Aspects:** Open-air nave, statues of elves with hands raised to the sky, floating orb

> *The central nave of this large circular temple is open to the sky above and adorned by five ancient statues of elf men and women—including a statue depicting the goddess of light—their faces and arms held up to the sky. An orb hangs in midair in the center of the open nave, glowing with scintillating colors. Rings of stone pews face a central fountain beneath the orb, which bubbles with warm water. A small circular house sits nearby, artfully decorated with symbols of the sun.*

Once an elven site, the temple has stood here for centuries, and was abandoned after the elves left this region to the human settlers who came after them. The main chamber of the temple is open to the sky through a stone entryway, while the stone rooms around it are roofed of clay and slate to protect the temple’s ceremonial items. A collapsed floor in the back of one storeroom of the temple leads into catacombs last explored centuries ago.

The scintillating orb has been present in the temple for as long as anyone can remember. Four years ago, enterprising thieves tried to steal the orb armed with an exceptionally tall ladder—only to have the lead thief disappear as soon as her fingers touched the orb, never to be seen again.

A nearby home is the residence of the temple’s current priest, Elovyn Sorrowsong.

### Whitesparrow Keep

**Area Aspects:** Stone three-story keep, switchback cobblestone road, enormous stone birdbath

> *A switchback cobblestone road leads up to the court-yard of Whitesparrow Keep, which stands majestically atop a rocky hill above the village. A large, still pool of water sits in the center of the keep’s main courtyard, with a granite statue of a sparrow sitting atop a rock in the pool’s center. Dozens of birds sit on perches around the pool’s edge, drinking from the pool and splashing about. The keep beyond stands three stories tall, with square turrets in the front and a pitched roof in the back.*

Not counting the temple, Whitesparrow keep is the oldest structure in the village, having survived numerous wars and other notable catastrophes. As castles go, it is not terribly large, although numerous subbasements lead deep into the rocky hill upon which the keep is built. Local rumors talk of how most of those subbasements haven’t been explored for hundreds of years.
